unit UnitPicture;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ExtDlgs, AXmsCtrl_TLB;

type
  TFormPicture = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ComboType: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    EditMCC: TEdit;
    EditFile: TEdit;
    ButtonBrowse: TButton;
    Panel2: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    EditMNC: TEdit;
    OpenPictureDialog: TOpenPictureDialog;
    procedure ButtonBrowseClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    objPicture  : ISmsDataPicture;
  public
    strMessage  : String;
  end;

var
  FormPicture: TFormPicture;

implementation

{$R *.dfm}

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormPicture.ButtonBrowseClick(Sender: TObject);
begin
  if OpenPictureDialog.Execute then EditFile.Text := OpenPictureDialog.FileName;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormPicture.ButtonOKClick(Sender: TObject);
var strError : String;
begin
  objPicture.BitmapFile   := EditFile.Text;
  objPicture.PictureType  := ComboType.ItemIndex;
  objPicture.NetworkCode  := StrToInt ( EditMNC.Text );
  objPicture.CountryCode  := StrToInt ( EditMCC.Text );

  objPicture.Encode       ();

  if ( objPicture.LastError <> 0 ) then  begin
    ModalResult := mrNone;

    strError := objPicture.GetErrorDescription ( objPicture.LastError );

    Application.MessageBox ( PAnsiChar ( strError ), 'Error' );
  end
  else
  begin
    strMessage := objPicture.EncodedMessage;
    ModalResult := mrOK;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormPicture.FormCreate(Sender: TObject);
begin
  objPicture := TSmsDataPicture.Create( Application ).DefaultInterface;

  ComboType.Items.Add ( 'Picture Message' );
  ComboType.Items.Add ( 'CLI Icon' );
  ComboType.Items.Add ( 'Operator Logo' );
  ComboType.Items.Add ( 'Clear Operator Logo' );

  ComboType.ItemIndex := 0;
end;

{////////////////////////////////////////////////////////////////////////////////}

end.
